if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface SelfDiscipline_Params {
    currentTime?: string;
    modeEnabled?: boolean;
    globalDarkMode?: boolean;
    listenerId?: string;
    timerId?: number;
}
import router from "@ohos:router";
import ThemeManager from "@bundle:com.example.myapplication/entry/ets/common/ThemeManager";
class SelfDiscipline extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__currentTime = new ObservedPropertySimplePU('', this, "currentTime");
        this.__modeEnabled = new ObservedPropertySimplePU(false, this, "modeEnabled");
        this.__globalDarkMode = new ObservedPropertySimplePU(false, this, "globalDarkMode");
        this.listenerId = '';
        this.timerId = 0;
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: SelfDiscipline_Params) {
        if (params.currentTime !== undefined) {
            this.currentTime = params.currentTime;
        }
        if (params.modeEnabled !== undefined) {
            this.modeEnabled = params.modeEnabled;
        }
        if (params.globalDarkMode !== undefined) {
            this.globalDarkMode = params.globalDarkMode;
        }
        if (params.listenerId !== undefined) {
            this.listenerId = params.listenerId;
        }
        if (params.timerId !== undefined) {
            this.timerId = params.timerId;
        }
    }
    updateStateVars(params: SelfDiscipline_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__currentTime.purgeDependencyOnElmtId(rmElmtId);
        this.__modeEnabled.purgeDependencyOnElmtId(rmElmtId);
        this.__globalDarkMode.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__currentTime.aboutToBeDeleted();
        this.__modeEnabled.aboutToBeDeleted();
        this.__globalDarkMode.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private __currentTime: ObservedPropertySimplePU<string>;
    get currentTime() {
        return this.__currentTime.get();
    }
    set currentTime(newValue: string) {
        this.__currentTime.set(newValue);
    }
    private __modeEnabled: ObservedPropertySimplePU<boolean>;
    get modeEnabled() {
        return this.__modeEnabled.get();
    }
    set modeEnabled(newValue: boolean) {
        this.__modeEnabled.set(newValue);
    }
    private __globalDarkMode: ObservedPropertySimplePU<boolean>;
    get globalDarkMode() {
        return this.__globalDarkMode.get();
    }
    set globalDarkMode(newValue: boolean) {
        this.__globalDarkMode.set(newValue);
    }
    private listenerId: string;
    private timerId: number;
    async aboutToAppear(): Promise<void> {
        this.globalDarkMode = await ThemeManager.getIsDarkMode();
        this.listenerId = ThemeManager.addListener((isDark: boolean) => {
            this.globalDarkMode = isDark;
        });
        this.updateTime();
        this.timerId = setInterval(() => {
            this.updateTime();
        }, 60000);
    }
    aboutToDisappear(): void {
        ThemeManager.removeListener(this.listenerId);
        if (this.timerId) {
            clearInterval(this.timerId);
        }
    }
    updateTime(): void {
        const now = new Date();
        this.currentTime = `${now.getHours().toString().padStart(2, '0')}:${now.getMinutes().toString().padStart(2, '0')}`;
    }
    enableMode(): void {
        this.modeEnabled = true;
    }
    getBackgroundColor(): string {
        return this.globalDarkMode ? '#000000' : '#FFFFFF';
    }
    getTextColor(): string {
        return this.globalDarkMode ? '#FFFFFF' : '#000000';
    }
    getCardColor(): string {
        return this.globalDarkMode ? '#1C1C1E' : '#F0F8FF';
    }
    getSecondaryTextColor(): string {
        return this.globalDarkMode ? '#8E8E93' : '#666666';
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 20 });
            Column.width('100%');
            Column.height('100%');
            Column.padding(20);
            Column.backgroundColor(this.getBackgroundColor());
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('自律模式');
            Text.fontSize(24);
            Text.fontWeight(FontWeight.Bold);
            Text.margin({ bottom: 30 });
            Text.fontColor(this.getTextColor());
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(`当前时间: ${this.currentTime}`);
            Text.fontSize(18);
            Text.width('100%');
            Text.textAlign(TextAlign.Start);
            Text.fontColor(this.getTextColor());
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('自律模式可以帮助您专注于当前任务，减少手机使用时间');
            Text.fontSize(14);
            Text.fontColor(this.getSecondaryTextColor());
            Text.width('100%');
            Text.textAlign(TextAlign.Start);
            Text.margin({ bottom: 40 });
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            If.create();
            if (!this.modeEnabled) {
                this.ifElseBranchUpdateFunction(0, () => {
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Button.createWithLabel('开启自律模式');
                        Button.type(ButtonType.Capsule);
                        Button.width('90%');
                        Button.height(55);
                        Button.backgroundColor('#007DFF');
                        Button.fontColor('#FFFFFF');
                        Button.fontSize(18);
                        Button.onClick(() => this.enableMode());
                    }, Button);
                    Button.pop();
                });
            }
            else {
                this.ifElseBranchUpdateFunction(1, () => {
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Column.create({ space: 15 });
                        Column.width('100%');
                        Column.padding(20);
                        Column.backgroundColor(this.getCardColor());
                        Column.borderRadius(12);
                    }, Column);
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Text.create('自律模式已开启');
                        Text.fontSize(18);
                        Text.fontColor('#007DFF');
                        Text.fontWeight(FontWeight.Bold);
                    }, Text);
                    Text.pop();
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Text.create('请专注于您的任务');
                        Text.fontSize(14);
                        Text.fontColor(this.getSecondaryTextColor());
                    }, Text);
                    Text.pop();
                    Column.pop();
                });
            }
        }, If);
        If.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Blank.create();
            Blank.layoutWeight(1);
        }, Blank);
        Blank.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('返回主页');
            Button.type(ButtonType.Normal);
            Button.width('90%');
            Button.height(45);
            Button.onClick(() => {
                router.back();
            });
        }, Button);
        Button.pop();
        Column.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "SelfDiscipline";
    }
}
registerNamedRoute(() => new SelfDiscipline(undefined, {}), "", { bundleName: "com.example.myapplication", moduleName: "entry", pagePath: "pages/SelfDiscipline", pageFullPath: "entry/src/main/ets/pages/SelfDiscipline", integratedHsp: "false" });
